package org.nhindirect.config.service.impl;

import java.net.URL;
import java.util.Properties;
import javax.jws.WebService;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.ValidateService;

import javax.mail.internet.MimeMessage;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.SmtpAgentException;
import org.nhindirect.gateway.smtp.SmtpAgentFactory;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.Message;

/**
 *
 * @author           <Bell_Adam@bah.com>
 */
@WebService(endpointInterface = "org.nhindirect.config.service.ValidateService")
public class ValidateServiceImpl implements ValidateService { 
    
    private static final Log log = LogFactory.getLog(ValidateServiceImpl.class);
    
    /**
     * Initialization method.
     */
    public void init() {
       log.info("ValidateService initialized");
    }
    
    public boolean validateTrust(String sender_address, String address) throws ConfigurationServiceException {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance(props, null);
        try {
            NHINDAddress sender = new NHINDAddress(sender_address);
            NHINDAddress recipient = new NHINDAddress(address);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add(recipient);
            MimeMessage mm = new MimeMessage(session);
            mm.setFrom(sender);
            mm.addRecipient(Message.RecipientType.TO, recipient);
            mm.setSubject("");
            mm.setText("");
            try {
                SmtpAgent agent = SmtpAgentFactory.createAgent(new URL("http://localhost:8081/config-service/ConfigurationService"));
                agent.processMessage(mm,recipients,sender);
            }
            catch (SmtpAgentException e)
            {
                log.error("Failed to create the SMTP agent: " + e.getMessage(), e);
                throw new MessagingException("Failed to create the SMTP agent: " + e.getMessage(), e);
            }
        }
        catch(Exception e) { e.printStackTrace(); return false; }
        
        return true;
    }
}
